using System;

namespace IndianHealthService.BMXNet.Tools.SchemaBuilder
{
	/// <summary>
	/// Represents a FIELD in a BMX ADO SCHEMA entry
	/// </summary>
	[Serializable]
	internal class BMXSchemaField: System.Object
	{
		internal BMXSchemaField()
		{
		}
		#region Fields
		private string	m_sFieldName;
		private double	m_nFieldNumber;

		#endregion Fields

		#region Properties
		/// <summary>
		/// Sets or returns the field number for this Schema Field
		/// </summary>
		internal double SchemaFieldNumber
		{
			get
			{
				return m_nFieldNumber;
			}
			set
			{
				m_nFieldNumber = value;
			}
		}

        private int m_nKey = 0;

		/// <summary>
		/// Getsthe IEN of the field subentry
		/// </summary>
		public int Key
		{
			get
			{
				return m_nKey;
			}
		}

		public string SchemaFieldName
		{
			get
			{
				return m_sFieldName;
			}
			set
			{
				m_sFieldName = value;
			}
		}

		#endregion Properties

	}
}
